/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8272;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8272.BoxInfo;
import ibm.nways.jdm8272.eui.ConfigurationAltGroup;
import ibm.nways.jdm8272.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8272.eui.FaultBaseGroup;
import ibm.nways.jdm8272.eui.SecurityBaseGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rmon.RmonContext;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.util.ResourceBundle;

public class Jdm8272
extends JdmBrowser {
    private static String bundleName = "ibm.nways.jdm8272.GeneralResources";
    private static String RootFolderTitle = "8272RootFolderTitle";
    private static String ConfigurationGroupTitle = "ConfigurationGroupTitle";
    private static String FaultGroupTitle = "FaultGroupTitle";
    private static String SystemGroupTitle = "SystemGroupTitle";
    private static String CommunicationsGroupTitle = "CommunicationsGroupTitle";
    private static String ServicesGroupTitle = "ServicesGroupTitle";
    private static String SystemGeneralInfoGroupTitle = "SystemGeneralInfoGroupTitle";
    private static String SystemPanelTitle = "SystemPanelTitle";
    private static String SnmpConfigPanelTitle = "SnmpConfigPanelTitle";
    private static String OtherAppsGroupTitle = "OtherAppsGroupTitle";
    private static String MibBrowserTitle = "MibBrowserTitle";
    private static String StartGraphic = "StartGraphic";
    private static String EndGraphic = "EndGraphic";
    private static String StartNavTree = "StartNavTree";
    private static String EndNavTree = "EndNavTree";
    private static final int RASID = 19;
    private static final int RASSUB = 22;
    private ResourceBundle myResources;
    BoxInfo boxInfo;
    private GraphicPanel deviceGraphicPanel;
    private boolean deviceResponding = false;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private NavFieldOverride myOverrides;
    static final Object[][] jdm8272FieldOverrides = new Object[][]{{"ibm.nways.mib2.model.Interface.Panel.IfPromiscuousMode.access", "read-only"}, {"ibm.nways.mib2.model.Interface.Panel.IfLinkUpDownTrapEnable.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IfDescr.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}};

    public String getModelTypeName() {
        return "ibm.nways.jdm8272.model.Jdm8272";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.navContext = this.rootFolder.getNavContext();
        if (this.navContext != null) {
            this.boxInfo.setLaunchData(this.navContext);
        }
        GraphicPanel graphicPanel = null;
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, (Object)this, "getDeviceGraphicPanel", "entry");
        }
        this.displayMsg(this.myResources.getString(StartGraphic));
        graphicPanel = this.boxInfo.getDeviceGraphic();
        this.displayMsg(this.myResources.getString(EndGraphic));
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, (Object)this, "getDeviceGraphicPanel", "exit");
        }
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        if (this.myResources == null) {
            this.myResources = ResourceBundle.getBundle(bundleName);
        }
        this.rootFolder = new NavigationFolder(this.myResources.getString(RootFolderTitle));
        this.navContext = this.rootFolder.getNavContext();
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, (Object)this, "getNavTreeRoot", "deviceModel is NULL!");
            }
        } else {
            if (this.deviceGraphicPanel != null) {
                this.deviceGraphicPanel.dispose();
                this.deviceGraphicPanel = null;
            }
            this.deviceResponding = true;
        }
        this.myOverrides = new NavFieldOverride(this.navContext, jdm8272FieldOverrides);
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(this.myResources.getString(StartNavTree));
        this.deviceResponding = this.boxInfo.getDeviceStatus() == 1;
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[]{1};
        RmonContext rmonContext = new RmonContext(nArray2, nArray3, nArray4);
        this.navContext.put((Object)"rmonContext", (Object)rmonContext);
        if (this.deviceModel != null && this.deviceResponding) {
            this.buildConfigurationFolder(this.rootFolder, false);
            this.buildFaultFolder(this.rootFolder);
            this.buildSecurityFolder(this.rootFolder);
            this.buildOtherAppsFolder(this.rootFolder);
        } else {
            this.buildConfigurationFolder(this.rootFolder, true);
            this.buildOtherAppsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, (Object)this, "getRestOfNavTree", "Box problems");
            }
        }
        this.displayMsg(this.myResources.getString(EndNavTree));
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Security");
        }
        catch (Exception exception) {
            RAS.logError(19, 22, (Object)this, "buildSecurityFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Security", (Object)"Jdm8272Model");
            RAS.logException(19, 22, (Object)this, "buildSecurityFolder", exception);
        }
        if (genModel != null) {
            SecurityBaseGroup securityBaseGroup = new SecurityBaseGroup((JdmBrowser)this, genModel);
            securityBaseGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)securityBaseGroup);
            navigationFolder.add((NavigationPoint)securityBaseGroup);
        }
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder, boolean bl) {
        if (this.deviceModel != null) {
            try {
                ConfigurationAltGroup configurationAltGroup;
                if (bl) {
                    GenModel genModel = (GenModel)this.deviceModel.getComponent("ConfigurationAltFolder");
                    configurationAltGroup = new ConfigurationAltGroup((JdmBrowser)this, genModel);
                    this.tree.addEventListener((NavigationBrowserEventListener)configurationAltGroup);
                } else {
                    GenModel genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
                    configurationAltGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
                    this.tree.addEventListener((NavigationBrowserEventListener)((ConfigurationFolderGroup)configurationAltGroup));
                }
                configurationAltGroup.setIsInitiallyExpanded(false);
                navigationFolder.add((NavigationPoint)configurationAltGroup);
                return;
            }
            catch (Exception exception) {
                RAS.logError(19, 22, (Object)this, "buildConfigurationFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"ConfigurationFolder", (Object)"Jdm8272Model");
                RAS.logException(19, 22, (Object)this, "buildConfigurationFolder", exception);
                return;
            }
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Fault");
        }
        catch (Exception exception) {
            RAS.logError(19, 22, (Object)this, "buildFaultFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Fault", (Object)"Jdm8272Model");
            RAS.logException(19, 22, (Object)this, "buildFaultFolder", exception);
        }
        if (genModel != null) {
            FaultBaseGroup faultBaseGroup = new FaultBaseGroup((JdmBrowser)this, genModel);
            faultBaseGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultBaseGroup);
            navigationFolder.add((NavigationPoint)faultBaseGroup);
        }
    }

    private void buildOtherAppsFolder(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = null;
        navigationFolder2 = new NavigationFolder(this.myResources.getString(OtherAppsGroupTitle));
        navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string, "-e vt100");
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(this.myResources.getString(MibBrowserTitle), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            WebContext webContext = new WebContext(string);
            webContext.only_nhd_url();
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
                return;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 22, (Object)this, "buildOtherAppsFolder", exception);
        }
    }
}

